package gov.va.med.mhv.integration.phr.stage.transfer;

import java.io.Serializable;

/** Alternate Key for stage records.
 * User: Rob Murtha
 */
public class StageEntityAK implements Serializable {

    private static final long serialVersionUID = 4499653678749819652L;
    private String icn;
    private long requestMsgCtrlId;
    private long responseMsgCtrlId;

    public StageEntityAK(String icn, long requestMsgCtrlId, long responseMsgCtrlId) {
        this.icn = icn;
        this.requestMsgCtrlId = requestMsgCtrlId;
        this.responseMsgCtrlId = responseMsgCtrlId;
        if(icn==null || requestMsgCtrlId==0 || responseMsgCtrlId==0) {
            throw new IllegalArgumentException("must provide icn, stationNumber, requestId, responseId");
        }
     }

    public String getIcn() {
        return icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public long getRequestMsgCtrlId() {
        return requestMsgCtrlId;
    }

    public void setRequestMsgCtrlId(long requestMsgCtrlId) {
        this.requestMsgCtrlId = requestMsgCtrlId;
    }

    public long getResponseMsgCtrlId() {
        return responseMsgCtrlId;
    }

    public void setResponseMsgCtrlId(long responseMsgCtrlId) {
        this.responseMsgCtrlId = responseMsgCtrlId;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof StageEntityAK)) return false;

        StageEntityAK that = (StageEntityAK) o;

        if (requestMsgCtrlId != that.requestMsgCtrlId) return false;
        if (responseMsgCtrlId != that.responseMsgCtrlId) return false;
        if (icn != null ? !icn.equals(that.icn) : that.icn != null) return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (icn != null ? icn.hashCode() : 0);
        result = 31 * result + (int) (requestMsgCtrlId ^ (requestMsgCtrlId >>> 32));
        result = 31 * result + (int) (responseMsgCtrlId ^ (responseMsgCtrlId >>> 32));
        return result;
    }


    public String toString() {
        return "StageEntityAK{" +
                "icn='" + icn + '\'' +
                ", requestMsgCtrlId=" + requestMsgCtrlId +
                ", responseMsgCtrlId=" + responseMsgCtrlId +
                '}';
    }


}
